<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Paper extends Model 
{

    protected $table = 'papers';
    public $timestamps = true;

    public function questions()
    {
        return $this->hasMany('App\Models\Question');
    }

    public function language()
    {
        return $this->belongsTo('App\Models\Language');
    }

    public function tasks()
    {
        return $this->belongsTo('App\Models\Task');
    }

    public function type()
    {
        return $this->belongsTo('App\Models\PaperType');
    }

}